/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.rcs.util.RcsException;
import com.ibm.hwmca.fw.rcs.util.RcsModemControl;
import com.ibm.hwmca.fw.rcs.util.RcsPppControl;
import com.ibm.hwmca.fw.rcs.util.RcsProperties;
import com.ibm.hwmca.fw.rcs.util.RcsTrace;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AttLink
extends RcsLink {
    private static final int DEFAULT_NUMBER_RETRY = 2;
    private static final int TIMEOUT_NUMBER = 120000;
    private static final int TIMEOUT_DIAL = 6000;
    private static final int ATT_MAX_PATHS = 1;
    private static final boolean ATT_HIGH_PERFORMANCE = false;
    private static AttLink sInstance;
    private int cNumberRetryCount = 2;
    private RcsPppControl cPpp = null;

    protected AttLink() {
        super(1, false);
    }

    public static synchronized AttLink getInstance() {
        return sInstance;
    }

    protected void setNumberRetryCount(int pNumberRetryCount) {
        this.cNumberRetryCount = pNumberRetryCount;
    }

    private void runRouteLogic() {
    }

    private boolean runPppLogic() throws LinkFailedException {
        int mPppRc;
        String mPppOpts;
        CustomerInfoData mCustData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        String mCountry = mCustData.getSystemCountryCode();
        String mRegion = mCustData.getSystemSubdivisionCode();
        ConnectionInfoManager mConnInfoMgr = ConnectionInfoManager.getConnectionInfoManager();
        AccountingInfo mAcctInfo = mConnInfoMgr.getAccountingInfo(this.getPath().getPlatform(), mCountry, mRegion);
        AccountInfo mAttInfo = mAcctInfo.getAccountInfo("Account_URSF");
        if (mAttInfo == null) {
            throw new LinkFailedException("Account information unavailable for " + mCountry + ", " + mRegion + ".");
        }
        String mUser = "internet." + mAttInfo.getAccount() + "." + mAttInfo.getUserId();
        String mPassword = "notused";
        try {
            RcsProperties mRcsConfig = new RcsProperties(new FileReader(BaseFileControl.getFilePath("rcsconfig") + "/rcsConfiguration.xml"));
            mPppOpts = mRcsConfig.get("AttPppOpts");
        }
        catch (Exception e) {
            throw new LinkFailedException("Failed to load rcsConfiguration: " + e);
        }
        this.cPpp = new RcsPppControl(1, mUser, mPassword, mPppOpts);
        try {
            mPppRc = this.cPpp.start();
        }
        catch (Exception e) {
            throw new LinkFailedException("An occurred while trying to start PPP.");
        }
        if (mPppRc == 0) {
            this.runRouteLogic();
            return true;
        }
        if (mPppRc == 1) {
            throw new LinkFailedException("PPP failed with a fatal error.");
        }
        if (mPppRc == 2) {
            throw new LinkFailedException("PPP failed because of bad options.");
        }
        if (mPppRc == 3) {
            throw new LinkFailedException("PPP failed because it was not execute as root.");
        }
        if (mPppRc == 4) {
            throw new LinkFailedException("No kernel support for PPP.");
        }
        if (mPppRc == 5) {
            this.dtrace("PPP was terminated by a signal.");
        } else {
            if (mPppRc == 6) {
                throw new LinkFailedException("PPP was unable to lock the terminal.");
            }
            if (mPppRc == 7) {
                throw new LinkFailedException("PPP was unable to open the terminal.");
            }
            if (mPppRc == 8) {
                throw new LinkFailedException("PPP connect script failed.");
            }
            if (mPppRc == 9) {
                throw new LinkFailedException("Could not set the proper PTY settings.");
            }
            if (mPppRc == 10) {
                this.dtrace("PPP could not properly negotiate with peer.");
            } else if (mPppRc == 11) {
                this.dtrace("Peer failed to authenticate itself.");
            } else if (mPppRc == 12) {
                this.dtrace("Link terminated due to idle timeout.");
            } else if (mPppRc == 13) {
                this.dtrace("Link terminated due to connectino time limit.");
            } else {
                if (mPppRc == 14) {
                    throw new LinkFailedException("PPP was asked to callback.");
                }
                if (mPppRc == 15) {
                    this.dtrace("PPP did not receive responses to it's echo.");
                } else if (mPppRc == 16) {
                    this.dtrace("Modem was hungup on PPP.");
                } else if (mPppRc == 17) {
                    this.dtrace("PPP negotiation failed because it detected a serial loopback.");
                } else if (mPppRc == 18) {
                    this.dtrace("PPP init script failed.");
                } else if (mPppRc == 19) {
                    this.dtrace("We failed to authenticate ourselves.");
                } else {
                    if (mPppRc == 200) {
                        throw new LinkFailedException("Unable to execute PPP.");
                    }
                    if (mPppRc == 201) {
                        this.dtrace("PPP process was killed by a signal.");
                    } else if (mPppRc == 300) {
                        this.dtrace("PPP took too long to initiate.");
                    }
                }
            }
        }
        return false;
    }

    protected boolean runDialLogic(List pNumberList) throws LinkFailedException {
        RcsModemControl mModem = RcsModemControl.getInstance();
        long mDialTimestamp = 0L;
        ModemConfigData mModemConfig = ModemConfigManager.getModemConfigManager().getModemConfig();
        HashMap<String, Long> mNumberTimestamp = new HashMap<String, Long>();
        for (int i = 0; i < this.cNumberRetryCount; ++i) {
            Iterator mIt = pNumberList.iterator();
            while (mIt.hasNext()) {
                int mDialRc;
                String mNumber = (String)mIt.next();
                if (mDialTimestamp > 0L) {
                    while (System.currentTimeMillis() - mDialTimestamp < 6000L) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                if (mNumberTimestamp.containsKey(mNumber)) {
                    long mTs = (Long)mNumberTimestamp.get(mNumber);
                    while (System.currentTimeMillis() - mTs < 120000L) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                mDialTimestamp = System.currentTimeMillis();
                mNumberTimestamp.put(mNumber, new Long(System.currentTimeMillis()));
                String mDialString = mModemConfig.getDialModeString() + mModemConfig.getDialPrefix() + mNumber;
                try {
                    mDialRc = mModem.startDial(mDialString);
                }
                catch (RcsException e) {
                    this.logInfo("Modem is being dial by someone else on the HMC.", e);
                    return false;
                }
                if (mDialRc == 0) {
                    this.dtrace("Successfully dialed: " + mDialString);
                    try {
                        if (this.runPppLogic()) {
                            return true;
                        }
                    }
                    catch (LinkFailedException mExc) {
                        this.ftrace("Disconnecting modem due to a PPP failure (" + mExc + ")");
                        mModem.stopDial();
                        throw mExc;
                    }
                    this.ftrace("PPP failed to start, disconnecting modem.");
                    mModem.stopDial();
                    continue;
                }
                if (mDialRc == 1 || mDialRc == 2) {
                    throw new LinkFailedException("There was a usage error while trying to dial.");
                }
                if (mDialRc == 10) {
                    throw new LinkFailedException("Failed to initialize the modem.");
                }
                if (mDialRc == 11) {
                    throw new LinkFailedException("Failed to reset the modem.");
                }
                if (mDialRc == 13) {
                    this.dtrace("Failed to lock modem, should be temporary");
                    return false;
                }
                if (mDialRc == 14) {
                    throw new LinkFailedException("Generic modem failure.");
                }
                if (mDialRc == 15) {
                    throw new LinkFailedException("Modem was unable to detect a carrier.");
                }
                if (mDialRc == 16) {
                    throw new LinkFailedException("Error communicating with the modem.");
                }
                if (mDialRc == 17) {
                    throw new LinkFailedException("Modem could not detect a dialtone.");
                }
                if (mDialRc == 18) {
                    this.dtrace("Phone number " + mDialString + " was busy.");
                    continue;
                }
                if (mDialRc == 19) {
                    this.dtrace("No answer from phone number " + mDialString);
                    continue;
                }
                if (mDialRc == 20) {
                    throw new LinkFailedException("Unexpect modem error occurred.");
                }
                throw new LinkFailedException("An unknown error code results from modem dialing (rc: " + mDialRc + " )");
            }
        }
        return false;
    }

    public boolean activate() throws LinkFailedException, LinkNotConfiguredException {
        this.ttrace("--> activate()");
        if (this.isActive()) {
            this.ftrace("Already active.");
            return true;
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        OutboundConfigData mOutConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        List mNumberInfo = mOutConfig.getPhoneInfo();
        ArrayList<String> mNumberList = new ArrayList<String>();
        Iterator mIt = mNumberInfo.iterator();
        while (mIt.hasNext()) {
            mNumberList.add(((PhoneInfo)mIt.next()).getDialString());
        }
        boolean mActive = this.runDialLogic(mNumberList);
        this.ttrace("<-- activate() [" + mActive + "]");
        return mActive;
    }

    public void deactivate() {
        this.ttrace("--> deactivate()");
        if (!this.isActive()) {
            return;
        }
        this.cPpp.stop();
        RcsModemControl.getInstance().stopDial();
        this.ttrace("<-- deactivate()");
    }

    public boolean isActive() {
        boolean mActive = this.cPpp != null && this.cPpp.isActive();
        this.ttrace("<-> isActive() [" + mActive + "]");
        return mActive;
    }

    public boolean fail() {
        this.ttrace("--> fail()");
        return true;
    }

    public boolean isConfigured() {
        OutboundConfigData mData = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean mConfigured = mData.isCallHomeServer() && mData.isAllowDial() && super.isConfigured();
        this.ttrace("<-> isConfigured() [" + mConfigured + "]");
        return mConfigured;
    }

    static {
        try {
            sInstance = new AttLink();
        }
        catch (Exception e) {
            RcsTrace.logInfoError("AttLink.static Exception", e);
        }
    }
}

